/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.TaskTag;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.builder.BuildPathManager;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.validation.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.util.Util;
import org2.eclipse.php.internal.core.preferences.ITaskTagsListener;
import org2.eclipse.php.internal.core.preferences.TaskTagsEvent;
import org2.eclipse.php.internal.core.preferences.TaskTagsProvider;

public class TaskTagsUpdater {
    private static final Pattern NEWLINE_SPLIT = Pattern.compile("\r\n|\r|\n");
    private static final String APTANA_TASK = "aptana_task";

    static {
        TaskTagsProvider.getInstance().addTaskTagsListener(new ITaskTagsListener(){

            public void taskCaseChanged(TaskTagsEvent event) {
                this.reparse(event);
            }

            private void reparse(TaskTagsEvent event) {
                IProject project = event.getProject();
                if (project != null) {
                    IBuildPath buildPathByResource = BuildPathManager.getInstance().getBuildPathByResource(project);
                    if (buildPathByResource != null) {
                        List modules = buildPathByResource.getModules();
                        List<IModule> emptyList = Collections.emptyList();
                        List<IDirectory> emptyDirList = Collections.emptyList();
                        PHPGlobalIndexer.getInstance().processChangedAfter(emptyList, modules, emptyList, emptyDirList, emptyDirList);
                    }
                } else {
                    List<IBuildPath> buildPaths = BuildPathManager.getInstance().getBuildPaths();
                    ArrayList<IModule> lm = new ArrayList<IModule>();
                    for (IBuildPath p : buildPaths) {
                        lm.addAll(p.getModules());
                    }
                    List<IModule> emptyList = Collections.emptyList();
                    List emptyDirList = Collections.emptyList();
                    PHPGlobalIndexer.getInstance().processChangedAfter(emptyList, lm, emptyList, emptyDirList, emptyDirList);
                }
            }

            public void taskPrioritiesChanged(TaskTagsEvent event) {
                this.reparse(event);
            }

            public void taskTagsChanged(TaskTagsEvent event) {
                this.reparse(event);
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHandleErrorsJob(Task[] errors, IFile file) {
        TaskTagsUpdater taskTagsUpdater = this;
        synchronized (taskTagsUpdater) {
            if (ResourcesPlugin.getWorkspace().isTreeLocked()) {
                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error updating the document errors. The workspace tree is locked.", (String)"com.aptana.editor.php/debug");
            }
            if (file == null || !file.exists()) {
                return;
            }
            int depth = 2;
            try {
                IMarker[] problemMarkers;
                Object[] objectArray = problemMarkers = file.findMarkers("org.eclipse.core.resources.taskmarker", true, depth);
                int n = problemMarkers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = objectArray[n2];
                    Object attribute2 = m.getAttribute(APTANA_TASK);
                    if (attribute2 != null && attribute2.equals("true")) {
                        m.delete();
                    }
                    ++n2;
                }
                objectArray = errors;
                n = errors.length;
                n2 = 0;
                while (n2 < n) {
                    IMarker t = objectArray[n2];
                    IMarker problemMarker = file.createMarker("org.eclipse.core.resources.taskmarker");
                    problemMarker.setAttribute("priority", t.getPriority());
                    problemMarker.setAttribute("charStart", t.getStart());
                    problemMarker.setAttribute("charEnd", t.getEnd());
                    problemMarker.setAttribute(APTANA_TASK, (Object)Boolean.TRUE.toString());
                    problemMarker.setAttribute("message", (Object)t.getDescription());
                    problemMarker.setAttribute("lineNumber", t.getLineNumber());
                    ++n2;
                }
            }
            catch (Exception e) {
                IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error updating the PHP task-tags.", (Throwable)e, (String)"com.aptana.editor.php/debug");
            }
        }
    }

    private static ISchedulingRule getMarkerRule(IResource resource) {
        ISchedulingRule rule = null;
        if (resource != null) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rule = ruleFactory.markerRule(resource);
        }
        return rule;
    }

    public void updateTaskTags(String contents, Program program, List<Comment> comments, IModule module) {
        try {
            if (module instanceof LocalModule) {
                LocalModule lm = (LocalModule)module;
                final IFile file = lm.getFile();
                Collection tags = TaskTag.getTaskTags();
                boolean isCaseSensitive = TaskTag.isCaseSensitive();
                program.setLineEndTable(Util.lineEndTable((IDocument)new Document(contents)));
                ArrayList<Task> tasks = new ArrayList<Task>();
                for (Comment comment : comments) {
                    tasks.addAll(this.processCommentNode(program, contents, isCaseSensitive, tags, comment));
                }
                final Task[] finalTasks = tasks.toArray(new Task[tasks.size()]);
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        TaskTagsUpdater.this.doHandleErrorsJob(finalTasks, file);
                    }
                };
                ResourcesPlugin.getWorkspace().run(runnable, TaskTagsUpdater.getMarkerRule((IResource)file), 1, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Error updating the PHP task-tags.", (Throwable)e, (String)"com.aptana.editor.php/debug");
        }
    }

    private Collection<Task> processCommentNode(Program program, String source, boolean isCaseSensitive, Collection<TaskTag> tags, Comment commentNode) {
        String[] lines;
        ArrayList<Task> tasks = new ArrayList<Task>();
        String text = new String(source.substring(commentNode.getStart(), Math.min(source.length(), commentNode.getEnd() + 1)));
        if (!isCaseSensitive) {
            text = text.toLowerCase();
        }
        int offset = 0;
        String[] stringArray = lines = NEWLINE_SPLIT.split(text);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            for (TaskTag entry : tags) {
                int index;
                String tag = entry.getName();
                if (!isCaseSensitive) {
                    tag = tag.toLowerCase();
                }
                if ((index = line.indexOf(tag)) == -1) continue;
                String message = line.substring(index).trim();
                if (message.endsWith("**/")) {
                    message = message.substring(0, message.length() - 3).trim();
                }
                if (message.endsWith("*/")) {
                    message = message.substring(0, message.length() - 2).trim();
                }
                int start = commentNode.getStart() + offset + index;
                tasks.add(new Task(entry.getName(), new String(message), entry.getPriority(), start, start + line.length() - index, program.getLineNumber(start)));
            }
            offset += line.length() + 1;
            ++n2;
        }
        return tasks;
    }
}

